unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    RadioButton1: TRadioButton;
    ListBox1: TListBox;
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    Capturando : Boolean;
    Origem,Final : TPoint;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Capturando :=  True;
  Origem := Point(X,Y);
  Final  := Point(X,Y);
// seta penas, brushes e desenha o retngulo
  with Canvas do begin
    Pen.Color := clBlack;
    Pen.Width := 1;
    Pen.Style := psDot;
    Brush.Style := bsClear;
    Pen.Mode := pmNotXor;
    Rectangle(Origem.X,Origem.Y,Final.X,Final.Y);
  end;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if Capturando then begin
// apaga quadro anterior
    Canvas.Rectangle(Origem.X,Origem.Y,Final.X,Final.Y);
// desenha novo quadro
    Canvas.Rectangle(Origem.X,Origem.Y,X,Y);
// seta quadro final
    Final := Point(X, Y);
  end;
end;

procedure TForm1.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  R : TRect;
  i : Integer;
begin
  if Capturando then begin
    Capturando := False;
    Canvas.Rectangle(Origem.X,Origem.Y,X,Y);
    Listbox1.Clear;
    for i := 0 to ComponentCount-1 do
      if Components[i] is TControl then
        with TControl(Components[i]) do begin
// verifica inteseco entre o quadro e o componente
          IntersectRect(R,Rect(Origem.X,Origem.Y,Final.X,Final.y),
            Rect(Left,Top,Left+Width,Top+Height));
// se ha interseco, adiciona na Listbox
          if not IsRectEmpty(R) then
            Listbox1.Items.Add(Name);
        end;
  end;
end;

end.
